<?php
// Função para salvar logs no arquivo
function salvarLog($mensagem) {
    $logFile = 'log_picpay.txt';
    if (!file_exists($logFile)) {
        file_put_contents($logFile, "Arquivo de log criado em: " . date('Y-m-d H:i:s') . PHP_EOL, FILE_APPEND);
    }
    file_put_contents($logFile, "[" . date('Y-m-d H:i:s') . "] " . $mensagem . PHP_EOL, FILE_APPEND);
}

try {
    // Lê o JSON recebido
    $json = file_get_contents('php://input');
    $resposta = json_decode($json);
    
    salvarLog("JSON bruto recebido: " . $json);
    salvarLog("Response decodificado: " . json_encode($resposta, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));

    // Verifica se a resposta contém o referenceId e authorizationId
    if (isset($resposta->referenceId) && isset($resposta->authorizationId)) {
        $referenceId = $resposta->referenceId;
        $reference_id_completo = $resposta->referenceId;

        // Divide o referenceId para obter id_pagamento e id_usuario
        list($id_pagamento, $id_usuario) = explode('__', $referenceId);

        // Buscar status da transação na API PicPay
        $transaction_id = $resposta->authorizationId;
        // Caminho para o arquivo JSON
        $arquivo = '../smsveloz/settings/credenciais.json';
        
        // Verifica se o arquivo existe
        if (file_exists($arquivo)) {
            // Lê o conteúdo do arquivo JSON
            $conteudo = file_get_contents($arquivo);
        
            // Decodifica o JSON em um array associativo
            $dados = json_decode($conteudo, true);
        
            // Acessa os dados específicos
            $token_picpay = $dados["token_picpay"];
        
        } else {
            echo "Arquivo 'credenciais.json' não encontrado.";
}
        $picPayToken =  $token_picpay; // Substitua pelo seu token

        $url = 'https://appws.picpay.com/ecommerce/public/payments/' . $reference_id_completo . '/status';
        $ch_status = curl_init();
        curl_setopt($ch_status, CURLOPT_URL, $url);
        curl_setopt($ch_status, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch_status, CURLOPT_HTTPHEADER, [
            'X-Picpay-Token: ' . $picPayToken
        ]);

        $result = curl_exec($ch_status);
        if (curl_errno($ch_status)) {
            salvarLog("Erro ao buscar status da transação: " . curl_error($ch_status));
            throw new Exception("Erro ao buscar status da transação.");
        }

        curl_close($ch_status);
        $respostaStatus = json_decode($result);
        salvarLog("Resposta da API de status: " . json_encode($respostaStatus, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));

        // Verifica se o status foi recuperado corretamente
        if (isset($respostaStatus->status)) {
            $status_final = $respostaStatus->status;
        
            // Conecta ao banco de dados
            $conn = new SQLite3('pagamentos_picpay.db');
            $query = "SELECT * FROM pagamentos WHERE id_pagamento = :id_pagamento AND id_usuario = :id_usuario";
            $stmt = $conn->prepare($query);
            $stmt->bindValue(':id_pagamento', $id_pagamento, SQLITE3_TEXT);
            $stmt->bindValue(':id_usuario', $id_usuario, SQLITE3_INTEGER);
            $result = $stmt->execute();
        
            if ($row = $result->fetchArray(SQLITE3_ASSOC)) {
                if ($status_final == 'paid') {
                    // Se o status for 'paid', atualiza para 'aprovado'
                    $updateQuery = "UPDATE pagamentos SET status = 'aprovado' WHERE id_pagamento = :id_pagamento AND id_usuario = :id_usuario";
                    $updateStmt = $conn->prepare($updateQuery);
                    $updateStmt->bindValue(':id_pagamento', $id_pagamento, SQLITE3_TEXT);
                    $updateStmt->bindValue(':id_usuario', $id_usuario, SQLITE3_INTEGER);
                    if ($updateStmt->execute()) {
                        echo 'Status atualizado para aprovado.';
                        salvarLog("Pagamento aprovado: ID {$id_pagamento}, Usuário {$id_usuario}");
                    } else {
                        echo 'Erro ao atualizar status.';
                        salvarLog("Erro ao atualizar status para ID {$id_pagamento}, Usuário {$id_usuario}");
                    }
                } elseif ($status_final == 'DECLINED') {
                    echo 'Pagamento recusado.';
                    salvarLog("Pagamento recusado: ID {$id_pagamento}, Usuário {$id_usuario}");
                } elseif ($status_final == 'IN_ANALYSIS') {
                    echo 'Pagamento em análise.';
                    salvarLog("Pagamento em análise: ID {$id_pagamento}, Usuário {$id_usuario}");
                } else {
                    echo 'Status desconhecido: ' . $status_final;
                    salvarLog("Status desconhecido ({$status_final}): ID {$id_pagamento}, Usuário {$id_usuario}");
                }
            } else {
                echo 'Pagamento não encontrado.';
                salvarLog("Pagamento não encontrado: ID {$id_pagamento}, Usuário {$id_usuario}");
            }
            $conn->close();
        } else {
            echo 'Falha ao obter status da transação.';
            salvarLog("Falha ao obter status da transação: " . $result);
        }
    } else {
        salvarLog("Resposta inválida do PicPay. Dados ausentes no JSON: " . json_encode($resposta, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
        echo 'Resposta inválida do PicPay.';
    }
} catch (Exception $e) {
    echo 'Erro ao processar a resposta.';
    salvarLog("Erro ao processar a resposta: " . $e->getMessage());
}
?>
