<?php

// Lê o JSON recebido e decodifica
$json = file_get_contents('php://input');
$resultado = json_decode($json);

// Inicializa a variável $status
$status = '';
foreach ($resultado->charges as $linha) {
    $status .= $linha->status;
}

// Inicializa a variável para armazenar a mensagem de log
$logMessage = json_encode($resultado);

// Verifica o status e define a mensagem de log
if ($status == 'PAID') {
    echo 'aprovado'; // Retorno para indicar o status

    $logMessage .= ' Status: ' . ($status == 'AUTHORIZED' ? 'AUTORIZADO' : 'PAGO') . ' - Transação aprovada';

    // Pega o ID da transação
    $id_transacao = $resultado->id;

    // Conecta ao banco de dados pagamentos_pagbank.db
    $pagbank_conn = new SQLite3('pagamentos_pagbank.db');

    // Verifica se o pagamento existe na tabela pagamentos e está como "pendente"
    $queryCheckPagamento = "SELECT status FROM pagamentos WHERE id_pagamento = :id_transacao";
    $stmtCheckPagamento = $pagbank_conn->prepare($queryCheckPagamento);
    $stmtCheckPagamento->bindValue(':id_transacao', $id_transacao, SQLITE3_TEXT);
    $resultCheck = $stmtCheckPagamento->execute();

    if ($row = $resultCheck->fetchArray(SQLITE3_ASSOC)) {
        if ($row['status'] == 'pendente') {
            // Atualiza o status para "aprovado"
            $queryUpdateStatus = "UPDATE pagamentos SET status = 'aprovado' WHERE id_pagamento = :id_transacao";
            $stmtUpdateStatus = $pagbank_conn->prepare($queryUpdateStatus);
            $stmtUpdateStatus->bindValue(':id_transacao', $id_transacao, SQLITE3_TEXT);
            if ($stmtUpdateStatus->execute()) {
                echo "Status do pagamento atualizado para aprovado.";
            } else {
                echo "Erro ao atualizar o status do pagamento.";
            }
        } else {
            echo "O pagamento já foi processado.";
        }
    } else {
        echo "Pagamento não encontrado no banco de dados.";
    }

    // Fecha a conexão com o banco de dados SQLite
    $pagbank_conn->close();
    
} elseif ($status == 'IN_ANALYSIS') {
    echo 'analise'; // Status da transação em análise
    $logMessage .= ' Status: EM ANÁLISE - Transação em análise';
} elseif ($status == 'DECLINED') {
    echo 'recusado'; // Status de transação recusada
    $logMessage .= ' Status: RECUSADO - Transação recusada';
} elseif ($status == 'CANCELED') {
    echo 'cancelado'; // Status de transação cancelada
    $logMessage .= ' Status: CANCELADO - Transação cancelada';
}

// Salva o log em um arquivo .txt para auditoria
$logFile = 'teste.txt';
file_put_contents($logFile, $logMessage . PHP_EOL, FILE_APPEND);
?>